ORCA/M Asm65816 2.1.0

0001 B100                       TITLE ', INIT.LOAD.a - myInitLoad'
0002 B100              *
0003 B100              ****************************************************************
0004 B100              *
0005 B100              *               private Initial Load subroutine
0006 B100              *               separated from main InitialLoad routines to
0007 B100              *               solve reentrancy problems.
0008 B100              *
0009 B100              *  Inputs:      (already stored in input_parms)
0010 B100              *               UserID (2 bytes)
0011 B100              *               Address of Load File Pathname (4 bytes)
0012 B100              *               Special Memory Flag (2 bytes)
0013 B100              *               Input Type (2 bytes)
0014 B100              *  Outputs:     UserID (2 bytes)
0015 B100              *               Starting Address (4 bytes)
0016 B100              *               Address of Direct Page/Stack (2 bytes)
0017 B100              *               Size of Direct Page/Stack (2 bytes)
0018 B100              *  Errors:      $0000 - Operation successful
0019 B100              *               $1102 - OMF Version error
0020 B100              *               $1104 - File not Load File
0021 B100              *               $1108 - UserID error
0022 B100              *               $1109 - SegNum out of sequence
0023 B100              *               $110A - Illegal load record found
0024 B100              *               $110B - Load Segment is foreign
0025 B100              *               $02xx - Memory Manager error
0026 B100              *               $00xx - ProDOS I/O error
0027 B100              *
0028 B100              ****************************************************************
0029 B100              *
0030 B100              myInitLoad Proc 
0031 B100                       with DirectPage, Globals
0032 B100                       Import delete_user_id,close_dynamic_file, \
0033 B100                       expand_path,open_load_file,check_express_seg, \ 
0034 B100                       alloc_id, get_express_seg, load_statics, save_start, \ 
0035 B100                       find_user_id, Setup_Buf_Ptrs 
0036 B100
0037 B100              IType    equ   input_parms              ;input Type
0038 B100              ISpecial equ   IType+2                  ;input Special Memory Flag
0039 B100              IAddress equ   ISpecial+2               ;input Address of Load File Name
0040 B100              IUserID  equ   IAddress+4               ;input UserID
0041 B100              OUserID  equ   3                        ;output UserID (allow for return address)
0042 B100              OAddress equ   OUserID+2                ;output Load Address
0043 B100              OZP_Addr equ   OAddress+4               ;output Direct Page/Stack Address
0044 B100              OZP_Size equ   OZP_Addr+2               ;output Direct Page/Stack Size
0045 B100
0046 B100
0047 B100 20 38 B4              jsr   InitInit                 ;common initialize
0048 B103              ;
0049 B103              ;        initialize output variables
0050 B103              ;
0051 B103 A9 00 00              lda   #0
0052 B106 83 05                 sta   OAddress,s               ;output Load Address
0053 B108 83 07                 sta   OAddress+2,s
0054 B10A 83 09                 sta   OZP_Addr,s               ;output Direct Page/Stack Address
0055 B10C 83 0B                 sta   OZP_Size,s               ;output Direct Page/Stack Size
0056 B10E
0057 B10E A5 E0                 lda   IType                    ;get the input type
0058 B110 F0 08                 beq   @old_style               ;type 0 means class 0 pathname supplied
0059 B112 C9 01 00              cmp   #$0001                   ;see if this is a pathname load
0060 B115 F0 13                 beq   @do_expand               ;this is a class 1 string
0061 B117 4C E9 B1              jmp   old_loader               ;else must be a System Loader call
0062 B11A              ;
0063 B11A              ;Now we need to do an Expand Path on the Input name.
0064 B11A              ;
0065 B11A              @old_style  
0066 B11A A5 E4                 lda   IAddress                 ;get the pointer to the pathname
0067 B11C A4 E6                 ldy   IAddress+2
0068 B11E A2 00 00              ldx   #0                       ;convert type 0 to type 1
0069 B121 20 4E F7              jsr   Convert_Pathname
0070 B124 A5 18                 lda   TempBuff                 ;get pointer to converted pathname
0071 B126 A4 1A                 ldy   TempBuff+2
0072 B128 80 04                 bra   @expand_it
0073 B12A              @do_expand  
0074 B12A A5 E4                 lda   IAddress
0075 B12C A4 E6                 ldy   IAddress+2
0076 B12E              @expand_it  
0077 B12E 20 96 F7              jsr   Expand_Pathname          ;perform an ExpandPath call
0078 B131 B0 63                 bcs   @error_exit
0079 B133
0080 B133 A5 18                 lda   TempBuff
0081 B135 85 CE                 sta   PathnamePtr
0082 B137 A5 1A                 lda   TempBuff+2
0083 B139 85 D0                 sta   PathnamePtr+2
0084 B13B
0085 B13B 20 69 DD              jsr   open_load_file           ;open the file please
0086 B13E B0 56                 bcs   @error_exit
0087 B140
0088 B140 A5 E8                 lda   IUserID                  ;go and get the user ID
0089 B142 20 AE D2              jsr   alloc_id
0090 B145 B0 1E                 bcs   @skip_to_error           ;pass the error back to the caller
0091 B147 83 03                 sta   OUserID,s
0092 B149 29 00 F0              and   #$F000
0093 B14C C9 00 10              cmp   #Application
0094 B14F D0 02                 bne   @not_app
0095 B151 E6 3A                 inc   Keep_Open
0096 B153              @not_app  
0097 B153 20 2D DB              jsr   check_express_seg        ;see if this is an expressload file
0098 B156 90 06                 bcc   @its_expressed
0099 B158 20 8C F1              jsr   Setup_Buf_Ptrs
0100 B15B 4C 58 B2              jmp   old_loader_continue      ;call the standard loader and let it try
0101 B15E              ;
0102 B15E              ;At this point all errors that we encounter must be returned to the caller since the file is mine.
0103 B15E              ;
0104 B15E              @its_expressed  
0105 B15E                                                      ;setup the special memory flag
0106 B15E A5 E2                 lda   ISpecial
0107 B160 85 B2                 sta   spec_mem_flag            ;user's preference
0108 B162
0109 B162 20 15 DC              jsr   get_express_seg          ;load in the express load segment
0110 B165              @skip_to_error  
0111 B165 B0 2F                 bcs   @error_exit              ;pass the error back to the caller
0112 B167
0113 B167 20 91 E3              jsr   load_statics             ;load all the static segments
0114 B16A B0 2B                 bcs   @dispose_exit            ;pass the error back to the caller
0115 B16C
0116 B16C 20 05 E4              jsr   save_start               ;save starting address and stack info
0117 B16F A5 DC                 lda   stack_size               ;return the correct parameters
0118 B171 83 0B                 sta   OZP_Size,s
0119 B173 A5 DA                 lda   stack_addr
0120 B175 83 09                 sta   OZP_Addr,s
0121 B177 AD A8 A6              lda   starting_addr+2          ;address of the Application
0122 B17A 29 FF 00              and   #$00FF
0123 B17D 83 07                 sta   OAddress+2,s
0124 B17F AD A6 A6              lda   starting_addr
0125 B182 83 05                 sta   OAddress,s
0126 B184 AD B6 A6              lda   |USERID
0127 B187 83 03                 sta   OUserID,s
0128 B189
0129 B189 F4 08 70              pea   uTempBuff                ;UserID
0130 B18C A2 02 11 22           _DisposeAll                    ;dispose of temporary memory
0131 B193
0132 B193 A9 00 00              lda   #$0000
0133 B196              @error_exit  
0134 B196 60                    rts                            ;we were successful!!
0135 B197
0136 B197              ; this is used when an error occurs after loading at least one segment into memory.
0137 B197              ; in this case, we must do a pseudo-userShutdown to clean up memory and dispose of
0138 B197              ; the user ID.
0139 B197
0140 B197              @dispose_exit  
0141 B197 48                    pha                            ;save the error code
0142 B198 AD B6 A6              lda   |USERID
0143 B19B 20 67 D4              jsr   find_user_id             ;get pointer to user_id_table
0144 B19E A0 02 00              ldy   #ID_Table_Entry.ExpressHandle
0145 B1A1 B7 62                 lda   [temp_ptr],y             ;get the ExpressLoad handle
0146 B1A3 85 88                 sta   ExpressHandle
0147 B1A5 C8                    iny   
0148 B1A6 C8                    iny   
0149 B1A7 B7 62                 lda   [temp_ptr],y
0150 B1A9 85 8A                 sta   ExpressHandle+2
0151 B1AB 20 C5 DC              jsr   close_dynamic_file       ;close file if any segments were dynamic
0152 B1AE
0153 B1AE A5 62                 lda   temp_ptr                 ;setup the User_ID pointer to point to the entry
0154 B1B0 85 7C                 sta   user_id_ptr
0155 B1B2 A5 64                 lda   temp_ptr+2
0156 B1B4 85 7E                 sta   user_id_ptr+2
0157 B1B6
0158 B1B6 48                    pha                            ;space for handle
0159 B1B7 48                    pha   
0160 B1B8 D4 7E                 pei   user_id_ptr+2            ;lock down the user ID table
0161 B1BA D4 7C                 pei   user_id_ptr
0162 B1BC A2 02 1A 22           _FindHandle 
0163 B1C3 A3 03                 lda   3,s                      ;duplicate the handle on the stack
0164 B1C5 48                    pha   
0165 B1C6 A3 03                 lda   3,s
0166 B1C8 48                    pha   
0167 B1C9 A2 02 20 22           _HLock 
0168 B1D0
0169 B1D0 A9 00 00              lda   #nuke_id                 ;delete the ID and the memory
0170 B1D3 20 BE D3              jsr   delete_user_id           ;remove the user_id please
0171 B1D6
0172 B1D6 A2 02 22 22           _HUnlock                       ;unlock the user ID table
0173 B1DD
0174 B1DD F4 08 70              pea   uTempBuff                ;UserID
0175 B1E0 A2 02 11 22           _DisposeAll                    ;dispose of temporary memory
0176 B1E7
0177 B1E7 68                    pla                            ;restore error code
0178 B1E8
0179 B1E8 60                    rts   
0180 B1E9
0181 B1E9                       entry type3_InitLoad
0182 B1E9              old_loader  
0183 B1E9              ;
0184 B1E9              ;        if Input Type is 3, get UserID from Pathname Table
0185 B1E9              ;
0186 B1E9 C9 03 00              cmp   #3
0187 B1EC D0 0A                 bne   cont1
0188 B1EE              type3_InitLoad  
0189 B1EE A0 08 00              ldy   #PT_UserID
0190 B1F1 B7 E4                 lda   [IAddress],y
0191 B1F3 8D B6 A6              sta   |USERID
0192 B1F6 80 0A                 bra   cont3
0193 B1F8              ;
0194 B1F8              ;        if Main ID field of input UserID is not 0, use UserID as is
0195 B1F8              ;
0196 B1F8              cont1     
0197 B1F8 A5 E8                 lda   IUserID                  ;go and get the user ID
0198 B1FA 20 AE D2              jsr   alloc_id
0199 B1FD 90 03                 bcc   @1
0200 B1FF 4C E2 B3              jmp   Error_Exit
0201 B202              @1        
0202 B202              ;
0203 B202              ;       set Keep Open flag if UserID is an Application type
0204 B202              ;
0205 B202 AA           cont3    tax                            ;save in X for a bit
0206 B203 29 00 F0              and   #$F000
0207 B206 C9 00 10              cmp   #Application
0208 B209 D0 02                 bne   cont3a
0209 B20B E6 3A                 inc   Keep_Open
0210 B20D              ;
0211 B20D              ;       if Input Type is 4, use the Loader's internal Resource UserID
0212 B20D              ;
0213 B20D              cont3a    
0214 B20D 8A                    txa   
0215 B20E 83 03                 sta   OUserID,s                ;save original UserID (with changes) as output
0216 B210 A5 E0                 lda   IType
0217 B212 C9 04 00              cmp   #4
0218 B215 D0 03                 bne   cont5
0219 B217 A2 09 70              ldx   #uResource
0220 B21A 8E B6 A6     cont5    stx   |USERID                  ;save in global USERID
0221 B21D
0222 B21D              ;
0223 B21D              ;        load IAddress into A,Y and point Open packet to a null string
0224 B21D              ;
0225 B21D A9 E0 B3              lda   #<zero
0226 B220 8D 2A A7              sta   |POpen.pathname
0227 B223 A9 01 00              lda   #^zero
0228 B226 8D 2C A7              sta   |POpen.pathname+2
0229 B229 A5 E4                 lda   IAddress
0230 B22B A4 E6                 ldy   IAddress+2
0231 B22D              ;
0232 B22D              ;        check Input Type
0233 B22D              ;
0234 B22D A6 E0                 ldx   IType
0235 B22F              ;
0236 B22F              ;        Input Type=2 or 4, set Memory Load Flag, and go right to Open
0237 B22F              ;
0238 B22F E0 02 00              cpx   #2
0239 B232 F0 05                 beq   cont6
0240 B234 E0 04 00              cpx   #4
0241 B237 D0 06                 bne   cont7
0242 B239              ;
0243 B239              ;       Input type must be 2 or 4 here
0244 B239              ;
0245 B239 E6 38        cont6    inc   Memory_Load
0246 B23B 5A                    phy   
0247 B23C 48                    pha   
0248 B23D 80 0D                 bra   cont10
0249 B23F              ;
0250 B23F              ;        Input Type=3, get pathname from Pathname Table
0251 B23F              ;
0252 B23F 18           cont7    clc   
0253 B240 69 1E 00              adc   #PT_Path
0254 B243 85 00                 sta   TempZero
0255 B245 90 01                 bcc   @1
0256 B247 C8                    iny   
0257 B248              @1        
0258 B248 84 02                 sty   TempZero+2
0259 B24A 5A                    phy   
0260 B24B 48                    pha   
0261 B24C              ;
0262 B24C              ;        open file
0263 B24C              ;
0264 B24C A9 00 00     cont10   lda   #0                       ;no time/date stamp
0265 B24F 48                    pha   
0266 B250 48                    pha   
0267 B251 48                    pha   
0268 B252 48                    pha   
0269 B253 20 E4 F1              jsr   Open_File
0270 B256 B0 54                 bcs   error_skip
0271 B258
0272 B258              old_loader_continue  
0273 B258              ;
0274 B258              ;        do pass 1
0275 B258              ;
0276 B258 64 1C                 stz   Pass                     ;Loader pass
0277 B25A 64 1E                 stz   Pass2_Needed             ;Pass2 Needed flag
0278 B25C 9C 22 A7              stz   |Header_Mark             ;set mark to 1st Segment Header
0279 B25F 9C 24 A7              stz   |Header_Mark+2
0280 B262 64 34                 stz   FirstMemSeg              ;set first Memory Segment entry to 0
0281 B264 64 36                 stz   FirstMemSeg+2
0282 B266 64 3C                 stz   Segment_Skipped          ;clear Segment Skipped flag
0283 B268 A6 E0                 ldx   IType                    ;if Input Type 3, use File Number
0284 B26A A9 01 00              lda   #1                       ;  from Pathname Table
0285 B26D E0 03 00              cpx   #3                       ;otherwise use 1
0286 B270 D0 05                 bne   cont11
0287 B272 A0 0A 00              ldy   #PT_FileNum
0288 B275 B7 E4                 lda   [IAddress],y
0289 B277 85 20        cont11   sta   CFileNum
0290 B279 A9 01 00              lda   #1
0291 B27C 85 22                 sta   CSegNum                  ;set Segment Number to 1
0292 B27E
0293 B27E              ;
0294 B27E              ;       Add the pathname to the pathname table.  We'll fill in the starting and
0295 B27E              ;       direct page addresses after we get the segments into memory.
0296 B27E              ;
0297 B27E E0 03 00              cpx   #3                       ;X still contains IType
0298 B281 B0 2B                 bcs   loop1
0299 B283
0300 B283 AD B6 A6              lda   |USERID                  ;UserID
0301 B286 48                    pha   
0302 B287 F4 01 00              pea   1                        ;File Number
0303 B28A AD 4A A7              lda   |POpen.modDateTime+6     ;mod_date
0304 B28D 48                    pha   
0305 B28E AD 48 A7              lda   |POpen.modDateTime+4
0306 B291 48                    pha   
0307 B292 AD 46 A7              lda   |POpen.modDateTime+2
0308 B295 48                    pha   
0309 B296 AD 44 A7              lda   |POpen.modDateTime
0310 B299 48                    pha   
0311 B29A A9 00 00              lda   #0                       ;Direct Page and Starting Address
0312 B29D 48                    pha                            ;will get filled in after we get the
0313 B29E 48                    pha                            ;segments loaded
0314 B29F 48                    pha   
0315 B2A0 48                    pha   
0316 B2A1 AD 2C A7              lda   |POpen.pathname+2        ;address of File Name
0317 B2A4 48                    pha   
0318 B2A5 AD 2A A7              lda   |POpen.pathname
0319 B2A8 48                    pha   
0320 B2A9 20 B4 F5              jsr   Add_Pathname
0321 B2AC              error_skip  
0322 B2AC B0 30                 bcs   error_skip_2
0323 B2AE              ;
0324 B2AE              ;        read next Segment Header
0325 B2AE              ;
0326 B2AE 20 26 EF     loop1    jsr   Next_Header
0327 B2B1 90 08                 bcc   cont14                   ;if no error, continue
0328 B2B3 C9 01 11              cmp   #NoFind                  ;is mark past EOF?
0329 B2B6 D0 26                 bne   error_skip_2             ;no, real error
0330 B2B8 4C 4B B3     cont12   jmp   end_pass1                ;pass is done
0331 B2BB
0332 B2BB              ;
0333 B2BB              ;        if this segment is Dynamic, skip it
0334 B2BB              ;
0335 B2BB AD CC A6     cont14   lda   Header.Kind
0336 B2BE 10 06                 bpl   cont15                   ;dynamic bit is bit 15
0337 B2C0              skip_it   
0338 B2C0 E6 3C                 inc   Segment_Skipped
0339 B2C2              eloop2    
0340 B2C2 E6 22                 inc   CSegNum                  ;(copied from eloop1)
0341 B2C4 80 E8                 bra   loop1                    ;repeat
0342 B2C6              ;
0343 B2C6              ;        if this segment is a Skip Segment, skip it
0344 B2C6              ;
0345 B2C6 89 00 02     cont15   bit   #Skip_Segment
0346 B2C9 D0 F5                 bne   skip_it
0347 B2CB              ;
0348 B2CB              ;        if this segment is a Library Dictionary Segment, skip it
0349 B2CB              ;
0350 B2CB 29 1F 00     cont16   and   #$1F
0351 B2CE C9 08 00              cmp   #Lib_Segment
0352 B2D1 F0 EF                 beq   eloop2
0353 B2D3              ;
0354 B2D3              ;        process segment
0355 B2D3              ;
0356 B2D3 64 24                 stz   CAddress                 ;set Segment Address to 0
0357 B2D5 64 26                 stz   CAddress+2
0358 B2D7 A6 E2                 ldx   ISpecial
0359 B2D9 20 06 E8              jsr   Do_Segment
0360 B2DC 90 03                 bcc   _1
0361 B2DE              error_skip_2  
0362 B2DE 4C E2 B3              jmp   Error_Exit
0363 B2E1              _1        
0364 B2E1              ;
0365 B2E1              ;       if Input Type is 4, change UserID of Segment to original UserID
0366 B2E1              ;
0367 B2E1 A5 E0                 lda   IType
0368 B2E3 C9 04 00              cmp   #4
0369 B2E6 D0 20                 bne   cont17
0370 B2E8 48                    pha                            ;output Handle
0371 B2E9 48                    pha   
0372 B2EA AD D2 A6              lda   Header.Org+2             ;Address of Segment
0373 B2ED 48                    pha   
0374 B2EE AD D0 A6              lda   Header.Org
0375 B2F1 48                    pha   
0376 B2F2 A2 02 1A 22           _FindHandle                    ;get Handle to Segment
0377 B2F9 FA                    plx   
0378 B2FA 7A                    ply   
0379 B2FB 86 08                 stx   Handle                   ;output Handle
0380 B2FD 84 0A                 sty   Handle+2
0381 B2FF B0 DD                 bcs   error_skip_2
0382 B301
0383 B301 A3 03                 lda   OUserID,s
0384 B303 A0 06 00              ldy   #6
0385 B306 97 08                 sta   [Handle],y
0386 B308              ;
0387 B308              ;        if this segment is an Initialization Segment, process it
0388 B308              ;
0389 B308 AD CC A6     cont17   lda   Header.Kind              ;KIND field
0390 B30B 29 1F 00              and   #$1F                     ;extract type
0391 B30E C9 10 00              cmp   #Init_Segment            ;is it Initialization type?
0392 B311 D0 0B                 bne   cont18
0393 B313 AD D0 A6              lda   Header.Org
0394 B316 AC D2 A6              ldy   Header.Org+2
0395 B319 20 4A E9              jsr   Do_Init_Segment
0396 B31C 80 28                 bra   eloop1
0397 B31E              ;
0398 B31E              ;        if this segment is the Direct Page/Stack segment, get its info
0399 B31E              ;        for ZP_Addr and ZP_Size
0400 B31E              ;
0401 B31E C9 12 00     cont18   cmp   #Direct_Segment
0402 B321 D0 0C                 bne   cont18a
0403 B323 AD D0 A6              lda   Header.Org
0404 B326 83 09                 sta   OZP_Addr,s
0405 B328 AD C0 A6              lda   Header.Length
0406 B32B 83 0B                 sta   OZP_Size,s
0407 B32D 80 17                 bra   eloop1
0408 B32F              ;
0409 B32F              ;        if the output Load Address is still 0, use load address in current
0410 B32F              ;        segment as OAddress
0411 B32F              ;
0412 B32F A3 05        cont18a  lda   OAddress,s
0413 B331 03 07                 ora   OAddress+2,s
0414 B333 D0 11                 bne   eloop1
0415 B335 AD D0 A6              lda   Header.Org
0416 B338 18                    clc   
0417 B339 6D DC A6              adc   Header.Entry
0418 B33C 83 05                 sta   OAddress,s
0419 B33E AD D2 A6              lda   Header.Org+2
0420 B341 6D DE A6              adc   Header.Entry+2
0421 B344 83 07                 sta   OAddress+2,s
0422 B346              ;
0423 B346              ;        increment current Segment Number
0424 B346              ;
0425 B346 E6 22        eloop1   inc   CSegNum
0426 B348 4C AE B2              jmp   loop1                    ;repeat
0427 B34B              ;
0428 B34B              ;       pass 1  is finished
0429 B34B              ;
0430 B34B              ;       if Keep_Open flag is set and there were no skipped
0431 B34B              ;       segments or input type is not 3, clear Keep_Open flag
0432 B34B              ;
0433 B34B A5 3A        end_pass1 lda   Keep_Open
0434 B34D F0 0D                 beq   cont19
0435 B34F A5 E0                 lda   IType
0436 B351 C9 03 00              cmp   #3
0437 B354 F0 3B                 beq   cont20
0438 B356 A5 3C                 lda   Segment_Skipped
0439 B358 D0 02                 bne   cont19
0440 B35A 64 3A                 stz   Keep_Open
0441 B35C              ;
0442 B35C              ;       if not Input Type 3 or 4, fill in Direct Page and Starting Address
0443 B35C              ;       entries in the Pathname Table
0444 B35C              ;
0445 B35C              cont19    
0446 B35C A5 E0                 lda   IType
0447 B35E C9 03 00              cmp   #3
0448 B361 B0 2E                 bcs   cont20
0449 B363
0450 B363 AD B6 A6              lda   |USERID                  ;UserID
0451 B366 48                    pha   
0452 B367 F4 01 00              pea   1                        ;File Number
0453 B36A AD 2C A7              lda   |POpen.pathname+2        ;address of File Name
0454 B36D 48                    pha   
0455 B36E AD 2A A7              lda   |POpen.pathname
0456 B371 48                    pha   
0457 B372 20 7B F6              jsr   Find_Pathname            ;find the pathname entry
0458 B375 90 04                 bcc   @got_it                  ;so far, so good
0459 B377 4B                    phk                            ;restore DBR
0460 B378 AB                    plb   
0461 B379 B0 67                 bcs   Error_Exit               ;not found?  Somethin's wierd!
0462 B37B              @got_it   
0463 B37B A3 09                 lda   OZP_Addr,s               ;Direct Page/Stack Address
0464 B37D 9D 14 00              sta   |PT_ZP_Addr,x            ;store into pathname table entry
0465 B380 A3 0B                 lda   OZP_Size,s               ;Direct Page/Stack Size
0466 B382 9D 16 00              sta   |PT_ZP_Size,x
0467 B385 A3 07                 lda   OAddress+2,s             ;Starting Address
0468 B387 9D 1C 00              sta   |PT_Address+2,x
0469 B38A A3 05                 lda   OAddress,s
0470 B38C 9D 1A 00              sta   |PT_Address,x
0471 B38F 4B                    phk                            ;restore DBR
0472 B390 AB                    plb   
0473 B391              ;
0474 B391              ;        dispose of Temporary Buffer
0475 B391              ;
0476 B391 F4 08 70     cont20   pea   uTempBuff                ;UserID
0477 B394 A2 02 11 22           _DisposeAll 
0478 B39B              ;
0479 B39B              ;        check whether another pass is needed
0480 B39B              ;
0481 B39B A5 1E                 lda   Pass2_Needed             ;is pass 2 needed?
0482 B39D F0 2C                 beq   cont21
0483 B39F              ;
0484 B39F              ;        another pass is needed, do pass 2
0485 B39F              ;
0486 B39F E6 1C                 inc   Pass
0487 B3A1              ;
0488 B3A1              ;        position file at Relocation Dictionary in current Segment
0489 B3A1              ;
0490 B3A1 A9 00 00              lda   #0                       ;output Offset
0491 B3A4 48                    pha   
0492 B3A5 48                    pha   
0493 B3A6 F4 00 00              pea   ML_FirstEntry>>16        ;Offset of 1st entry
0494 B3A9 F4 08 00              pea   |ML_FirstEntry
0495 B3AC 20 0E F1     loop2    jsr   Next_Dictionary
0496 B3AF FA                    plx                            ;output offset
0497 B3B0 7A                    ply   
0498 B3B1 B0 2F                 bcs   Error_Exit
0499 B3B3              ;
0500 B3B3              ;        if CSegNum=0, there are no more entries in Mark List
0501 B3B3              ;
0502 B3B3 A5 22                 lda   CSegNum
0503 B3B5 F0 14                 beq   cont21
0504 B3B7              ;
0505 B3B7              ;        process Segment
0506 B3B7              ;
0507 B3B7 5A                    phy                            ;save next Mark List Offset
0508 B3B8 DA                    phx   
0509 B3B9 A6 E2                 ldx   ISpecial
0510 B3BB 20 06 E8              jsr   Do_Segment
0511 B3BE FA                    plx                            ;Mark List Offset
0512 B3BF 7A                    ply   
0513 B3C0 B0 20                 bcs   Error_Exit
0514 B3C2
0515 B3C2 A9 00 00              lda   #0                       ;output OffSet
0516 B3C5 48                    pha   
0517 B3C6 48                    pha   
0518 B3C7 5A                    phy                            ;Mark List Offset
0519 B3C8 DA                    phx   
0520 B3C9
0521 B3C9 80 E1                 bra   loop2
0522 B3CB
0523 B3CB              ;
0524 B3CB              ;       if Input Type 4, remove all entries for this Resource from the Memory Segment Table
0525 B3CB              ;
0526 B3CB A5 E0        cont21   lda   IType
0527 B3CD C9 04 00              cmp   #4
0528 B3D0 D0 0D                 bne   return
0529 B3D2 AD B6 A6              lda   |USERID                  ;UserID
0530 B3D5 48                    pha   
0531 B3D6 F4 01 00              pea   SEGTBL>>16               ;Memory Segment Table
0532 B3D9 F4 AA A6              pea   |SEGTBL
0533 B3DC 20 C8 F8              jsr   Remove_UserID
0534 B3DF
0535 B3DF A9 00 00     return   lda   #0
0536 B3E2              zero     equ   return+1                 ;location containing zero
0537 B3E2              ;
0538 B3E2              ;        exit cleanup
0539 B3E2              ;
0540 B3E2 48           Error_Exit pha                          ;save status
0541 B3E3              ;
0542 B3E3              ;        close file
0543 B3E3              ;
0544 B3E3 20 0E F3              jsr   Close_File
0545 B3E6              ;
0546 B3E6              ;        dispose of Mark List
0547 B3E6              ;
0548 B3E6 F4 07 70              pea   uMarkList                ;UserID
0549 B3E9 A2 02 11 22           _DisposeAll 
0550 B3F0              ;
0551 B3F0              ;        dispose of temporary buffers
0552 B3F0              ;
0553 B3F0 F4 08 70              pea   uTempBuff                ;UserID
0554 B3F3 A2 02 11 22           _DisposeAll 
0555 B3FA              ;
0556 B3FA              ;        if an error occurred, and not Input Type 3, do complete shutdown of userid
0557 B3FA              ;
0558 B3FA A3 01                 lda   1,s                      ;retrieve status from stack
0559 B3FC F0 13                 beq   cont22                   ;no errors!
0560 B3FE A5 E0                 lda   IType
0561 B400 C9 03 00              cmp   #3
0562 B403 F0 0C                 beq   cont22
0563 B405 48                    pha                            ;make space for output UserID
0564 B406 AD B6 A6              lda   |USERID                  ;input UserID
0565 B409 85 E2                 sta   input_parms+2            ;set up direct page for UserShutdown call
0566 B40B 64 E0                 stz   input_parms              ;Quit Flag
0567 B40D 20 9F AE              jsr   myUserShutdown           ;make the call
0568 B410 68                    pla                            ;remove output UserID
0569 B411
0570 B411 68           cont22   pla                            ;restore status
0571 B412 60                    rts                            ;back to caller
0572 B413
0573 B413                       EndP 
0574 B413
0575 B413                       TITLE ', INIT.LOAD.a - InitLoad'
0576 B413              *
0577 B413              ****************************************************************
0578 B413              *
0579 B413              *              Initial Load ($09)
0580 B413              *
0581 B413              *  Inputs:     UserID (2 bytes)
0582 B413              *              Address of Load File Pathname (4 bytes)
0583 B413              *              Special Memory Flag (2 bytes)
0584 B413              *  Outputs:    UserID (2 bytes)
0585 B413              *              Starting Address (4 bytes)
0586 B413              *              Address of Direct Page/Stack (2 bytes)
0587 B413              *              Size of Direct Page/Stack (2 bytes)
0588 B413              *  Errors:     $0000 - Operation successful
0589 B413              *              $1102 - OMF Version error
0590 B413              *              $1104 - File not Load File
0591 B413              *              $1108 - UserID error
0592 B413              *              $1109 - SegNum out of sequence
0593 B413              *              $110A - Illegal load record found
0594 B413              *              $110B - Load Segment is foreign
0595 B413              *              $02xx - Memory Manager error
0596 B413              *              $00xx - ProDOS I/O error
0597 B413              *
0598 B413              ****************************************************************
0599 B413              *
0600 B413              InitLoad PROC 
0601 B413                       LoadSegCheck 
0602 B413
0603 B413                       with DirectPage, Globals
0604 B413
0605 B413 A2 08 00              ldx   #func_9_param_cnt        ;get the number of parameters of the stack
0606 B416 20 C6 B9              jsr   get_parameters
0607 B419
0608 B419              ISpecial equ   input_parms              ;input  Special Memory Flag
0609 B419              IAddress equ   ISpecial+2               ;input  Address of Load File Name
0610 B419              IUserID  equ   IAddress+4               ;input  UserID
0611 B419              OUserID  equ   1                        ;output UserID
0612 B419              OAddress equ   OUserID+2                ;output Load Address
0613 B419              OZP_Addr equ   OAddress+4               ;output Direct Page/Stack Address
0614 B419              OZP_Size equ   OZP_Addr+2               ;output Direct Page/Stack Size
0615 B419
0616 B419              ;
0617 B419              ;       translate the call into an InitialLoad2 call internally
0618 B419              ;
0619 B419 A2 06 00              ldx   #IUserID-ISpecial        ;move input parameters to correct locations
0620 B41C              @loop     
0621 B41C B5 E0                 lda   ISpecial,x               ;get a word
0622 B41E 95 E2                 sta   ISpecial+2,x             ;and move it
0623 B420 CA                    dex   
0624 B421 CA                    dex   
0625 B422 10 F8                 bpl   @loop                    ;until all moved
0626 B424 64 E0                 stz   ISpecial                 ;make this a type 0 InitialLoad2 call
0627 B426
0628 B426 20 00 B1              jsr   myInitLoad               ;call the real workhorse
0629 B429
0630 B429 4C 1B BA              jmp   return_to_caller         ;back to application
0631 B42C
0632 B42C                       ENDP 
0633 B42C
0634 B42C                       TITLE ', INIT.LOAD.a - InitLoad2'
0635 B42C              *
0636 B42C              ****************************************************************
0637 B42C              *
0638 B42C              *              Initial Load 2 ($20)
0639 B42C              *
0640 B42C              *  Inputs:     UserID (2 bytes)
0641 B42C              *              Address of Load File Pathname (4 bytes)
0642 B42C              *              Special Memory Flag (2 bytes)
0643 B42C              *              Input Type (2 bytes)
0644 B42C              *  Outputs:    UserID (2 bytes)
0645 B42C              *              Starting Address (4 bytes)
0646 B42C              *              Address of Direct Page/Stack (2 bytes)
0647 B42C              *              Size of Zero Page/Stack (2 bytes)
0648 B42C              *  Errors:     $0000 - Operation successful
0649 B42C              *              $1102 - OMF Version error
0650 B42C              *              $1104 - File not Load File
0651 B42C              *              $1108 - UserID error
0652 B42C              *              $1109 - SegNum out of sequence
0653 B42C              *              $110A - Illegal load record found
0654 B42C              *              $110B - Load Segment is foreign
0655 B42C              *              $02xx - Memory Manager error
0656 B42C              *              $00xx - ProDOS I/O error
0657 B42C              *
0658 B42C              *  Input Type - 0 Pathname is Type 0 Pathname
0659 B42C              *               1 Pathname is Type 1 Pathname
0660 B42C              *               2 Address points to a packet containing:
0661 B42C              *
0662 B42C              *                   Starting Address of In Memory Load  File (4 bytes)
0663 B42C              *                   Length  of In Memory Load File (2 bytes)
0664 B42C              *
0665 B42C              *               3 Address points to a Pathname Table entry
0666 B42C              *               4 Address points to a packet containing:
0667 B42C              *
0668 B42C              *                   Starting Address of Code Resource in memory (4 bytes)
0669 B42C              *                   Length of Code Resource (2 bytes)
0670 B42C              *
0671 B42C              *   The Load File is kept open if:
0672 B42C              *
0673 B42C              *       The UserID has Application type AND
0674 B42C              *       Input Type is 3 OR
0675 B42C              *       Some Load Segments were skipped (dynamic or skip)
0676 B42C              *
0677 B42C              ****************************************************************
0678 B42C              *
0679 B42C              InitLoad2 PROC Export
0680 B42C                       LoadSegCheck 
0681 B42C
0682 B42C A2 0A 00              ldx   #func_20_param_cnt       ;get the number of parameters of the stack
0683 B42F 20 C6 B9              jsr   get_parameters
0684 B432
0685 B432 20 00 B1              jsr   myInitLoad               ;call the _real_ InitialLoad function
0686 B435
0687 B435 4C 1B BA              jmp   return_to_caller
0688 B438
0689 B438                       ENDP 
0690 B438
0691 B438                       TITLE ', INIT.LOAD.a - InitInit'
0692 B438              *
0693 B438              ****************************************************************
0694 B438              *
0695 B438              *              Initial Load and Restart Initialization
0696 B438              *
0697 B438              ****************************************************************
0698 B438              *
0699 B438              InitInit PROC 
0700 B438                       with DirectPage, Globals
0701 B438              ;
0702 B438              ;        initialize globals
0703 B438              ;
0704 B438 9C B6 A6              stz   |USERID                  ;global USERID
0705 B43B
0706 B43B              ;
0707 B43B              ;        initialize zero page variables
0708 B43B              ;
0709 B43B 64 38                 stz   Memory_Load              ;clear Memory Load flag
0710 B43D 64 3A                 stz   Keep_Open                ;clear Keep Open flag
0711 B43F              ;
0712 B43F              ;        cleanup Loader tables
0713 B43F              ;
0714 B43F F4 00 00              pea   0                        ;all UserID's
0715 B442 20 A0 F9              jsr   Cleanup
0716 B445
0717 B445 60                    rts   
0718 B446
0719 B446                       ENDP 
0720 B446
0721 B446
